/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class LookFor88XScreen
extends UpgradeScreen {
    private final String btnCancelCmd = "CANCEL";
    private final String doneCmd = "DONE";
    private JProgressBar m_progressBar;
    private Device88X m_Dev88X;
    private Thread m_netThread;
    private Action m_act;

    public LookFor88XScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying Look for 88X Window");
        super.finalize();
        this.m_progressBar = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        this.m_act = new UpgradeScreen.AutomaticActionEvent(this, actionListener);
        JLabel jLabel = new JLabel("Checking again for the 88X Generator on the network.");
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setIndeterminate(true);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setPreferredSize(new Dimension(500, 20));
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        jPanel.add(this.m_progressBar);
        JPanel jPanel2 = new JPanel();
        super.setLogo(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        container.add((Component)jPanel2, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public void run(Device88X device88X) {
        this.m_Dev88X = device88X;
        this.m_netThread = new Thread(new runCheckEthernet(super.getJFrame()));
        this.m_netThread.setName("Look for 88X Thread");
        this.m_netThread.start();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("DONE".equalsIgnoreCase(actionEvent.getActionCommand())) {
            n2 = 9;
        }
        return n2;
    }

    class runCheckEthernet
    implements Runnable {
        private JFrame runFrame;

        public runCheckEthernet(JFrame jFrame) {
            this.runFrame = jFrame;
        }

        public synchronized void run() {
            int n;
            ActionEvent actionEvent = new ActionEvent(this, 1001, "DONE");
            LookFor88XScreen.this.m_act.setEnabled(true);
            do {
                if (LookFor88XScreen.this.m_Dev88X.IsDeviceThere(this.runFrame)) {
                    n = -2;
                    continue;
                }
                Object[] objectArray = new Object[]{"Retry", "Cancel Upgrade"};
                n = JOptionPane.showOptionDialog(this.runFrame, "Could not find " + LookFor88XScreen.this.m_Dev88X.getIPAddress() + "\nPlease plug the 88X into the network", "Host Not Found", 1, 2, null, objectArray, objectArray[0]);
            } while (n == 0);
            if (n == 1 || n == -1) {
                System.out.println("Exiting");
                System.exit(0);
            }
            LookFor88XScreen.this.m_act.actionPerformed(actionEvent);
        }
    }
}

